$(document).ready(function () {
    $('.change_password').modal({
        show: false,
        backdrop: false
    }); 

    $("#change_password").on("click", function (e) {
        e.preventDefault();
        var password = $('.change_password input[type="password"]').val(),
            btn = $(this);
        if ( password == '' ) {
            swal({
                title: "تنبيه",
                text: "قم بملئ الحقل أولاً",
                icon: "warning",
                button: "حسناً",
              });
        } else if ( password.length < 4 ) {
            swal({
                title: "تنبيه",
                text: "كلمة المرور يجب أن لا تقل عن 4 حروف",
                icon: "warning",
                button: "حسناً",
              });
        } else if ( password.length > 10 ) {
            swal({
                title: "تنبيه",
                text: "كلمة المرور يجب أن لا تزيد عن 10 حروف",
                icon: "warning",
                button: "حسناً",
              });
        } else {
            $.ajax({
                url: '/dashboard/changePassword',
                method: 'POST',
                data: {change_password: true, password: password},
                beforeSend: function () {
                    btn.text('جارِ الحفظ');
                },
                success: function (data) {
                    btn.text('حفظ');
                    if ( data.type == 'error' ) {
                        swal({
                            title: "تنبيه",
                            text: data.message,
                            icon: "warning",
                            button: "حسناً",
                          });
                    } else {
                        swal({
                            title: "نجاح",
                            text: data.message,
                            icon: "success",
                            button: "حسناً",
                          }); 
                    }
                },
                error: function () {

                }
            });
        }
    });

});