<?php
namespace syriashop\modals;
use \syriashop\lib\Languages;

class UsersModals extends AbstractModals {
    use \syriashop\lib\Messages;
    
    public $name, $date_register, $gender, $familay, $mony, $plu, $message;
    
    protected static $tableName = "users";
    protected static $tableSchema = array(
        "name" => self::DATA_TYPE_STR,
        "date_register" => self::DATA_TYPE_STR,
        "gender" => self::DATA_TYPE_STR,
        "familay" => self::DATA_TYPE_INT,
        "mony" => self::DATA_TYPE_STR,
        "plu" => self::DATA_TYPE_STR
    );
    protected static $primaryKey = "id";

    public function checkName(){
        $existsError = false;
        if ( empty($this->name) ) {
            $this->message[] = $this->message("danger", Languages::lang("signin_notEmptyUserName", $GLOBALS["lang"]));
            $existsError = true;
        } else if ( mb_strlen($this->name) < 2 || mb_strlen($this->name) > 25 ) {
            $this->message[] = $this->message("danger", Languages::lang("signin_countUserName", $GLOBALS["lang"]));
            $existsError = true;
        }
        return $existsError ? true : false;
    }
    public function showMessage(){
        return $this->message;
    }
    
}
