<?php
namespace syriashop\controllers;
use \syriashop\lib\Languages;
use syriashop\modals\AdminModals;
use syriashop\modals\DashboardModals;
use syriashop\modals\UsersModals;

class DashboardController extends AbstractController {
    use \syriashop\lib\Redirect; // استخدام تريت اعادة التحويل
    use \syriashop\lib\FilterInput;
    use \syriashop\lib\Messages;
    use \syriashop\lib\Database;

    // Page Default
    public function defaultAction(){
        if ( isset($_SESSION['dashboard']) ) {
            $this->headerTo('/dashboard/statistics');
        }
        $this->_view();
    }
    public function signInAction(){
        if ( isset($_POST['signin_admin']) ) {
            $signIn = new DashboardModals;
            $signIn->name = $this->filterStr($_POST['admin_name']);
            $signIn->password = $this->filterStr($_POST['admin_password']);
            if ( $signIn->getByColumn('name', $signIn->name) ) {
                if ( $signIn->getByColumn('password', md5($signIn->password)) ) {
                    $result['type'] = 'success';
                    $result['message'] = "البيانات صحيحة";
                    $_SESSION['dashboard']['admin'] = $signIn->name;
                } else {
                    $result['type'] = 'error';
                    $result['message'] = "كلمة المرور غير صحيحة";
                }
            } else {
                $result['type'] = "error";
                $result['message'] = "اسم الأدمن غير صحيح";
            }
            header("content-type: application/json");
            echo json_encode($result);
        } else {
            $this->headerTo('/dashboard/');
        }
    }

    public function changePasswordAction(){
        if ( isset($_POST['change_password']) ) {
            $password = $_POST['password'];
            if ( $password == '' ) {
                $result['type'] = 'error';
                $result['message'] = 'قم بملئ الحقل أولاً';
            } else if ( mb_strlen($password) < 4 ) {
                $result['type'] = 'error';
                $result['message'] = 'كلمة المرور يجب أن لا تقل عن 4 حروف';
            } else if ( mb_strlen($password) > 10 ) {
                  $result['type'] = 'error';
                  $result['message'] = 'كلمة المرور يجب أن لا تزيد عن 10 حروف';
            } else {
                $admin = new AdminModals;
                $admin->password = md5($password);
                if ( $admin->updateSingle("password = '{$admin->password}'", 'id = 1') ){
                    $result['type'] = 'success';
                    $result['message'] = 'تم تغيير كلمة المرور بنجاح';
                } else {
                    $result['type'] = 'error';
                    $result['message'] = 'حدث خطأ غير متوقع';
                }
            }
            header("content-type: application/json");
            echo json_encode($result);
        }
    }

    public function statisticsAction(){
        $users = new UsersModals;

        // احصائيات المستحدمين
        $statistc = $users->sql("date_register, count(*) as countUser",
                "users", "where date_register >= DATE_SUB(NOW(), INTERVAL 1 week) GROUP BY day(date_register) ", "", "all");
        $statistcUsers = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcUsers .= "{label: '" . date("Y-m-d", strtotime($st->date_register)) . "', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcUsers"] = 0;
        }
        $statistcUsers = substr($statistcUsers, 0, -2);
        $this->_data["statistcUsers"] = $statistcUsers;
        
        // احصائيات الجنس
        //y: '2024', a: 160, b: 95
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where gender = 'male'", "", "all");
        $statistcGender = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcGender .= "{label: 'ذكر', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcGender"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where gender = 'female'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcGender .= "{label: 'انثى', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcGender"] = 0;
        }
        $statistcGender = substr($statistcGender, 0, -2);
        $this->_data["statistcGender"] = $statistcGender;
        
        // احصائيات العائلات
        //y: '2024', a: 160, b: 95
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where familay = 1", "", "all");
        $statistcFamilay = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'الطربوش', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where familay = 2", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'العقال', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where familay = 3", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'القبعات', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistcFamilay = substr($statistcFamilay, 0, -2);
        $this->_data["statistcFamilay"] = $statistcFamilay;
        
        
        // المرأة تكون مقاول
        //y: '2024', a: 160, b: 95
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'undoing'", "", "all");
        $statistcFamilay = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'المرأة مقاولة', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where familay = 1", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'المرأة فنانة', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where familay = 2", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcFamilay .= "{label: 'قول الحقيقة', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcFamilay"] = 0;
        }
        $statistcFamilay = substr($statistcFamilay, 0, -2);
        $this->_data["statistcFamilay"] = $statistcFamilay;
        

        // احصائيات انواع الناس
        //y: '2024', a: 160, b: 95
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'peace_plus'", "", "all");
        $statistcPlu = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcPlu .= "{label: 'السلام', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcPlu"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'peace_sub'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcPlu .= "{label: 'العنف', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcPlu"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'law_plus'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcPlu .= "{label: 'مع القوانين', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcPlu"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'law_sub'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcPlu .= "{label: 'القفز فوق القوانين', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcPlu"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where plu = 'undoing'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcPlu .= "{label: 'عدم فعل شيء', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcPlu"] = 0;
        }
        $statistcPlu = substr($statistcPlu, 0, -2);
        $this->_data["statistcPlu"] = $statistcPlu;

        // احصائيات المال
        //y: '2024', a: 160, b: 95
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where mony = 'rich'", "", "all");
        $statistcMony = "";
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcMony .= "{label: 'الأغنياء', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcMony"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where mony = 'poor'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcMony .= "{label: 'الفقراء', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcMony"] = 0;
        }
        $statistc = $users->sql("date_register, count(*) as countUser", "users", "where mony = 'medium'", "", "all");
        if ( !empty($statistc) ) {
            foreach ($statistc as $st ) {
                $statistcMony .= "{label: 'متوسط', value: {$st->countUser}}, ";
            }
        } else {
            $this->_data["statistcMony"] = 0;
        }
        $statistcMony = substr($statistcMony, 0, -2);
        $this->_data["statistcMony"] = $statistcMony;
        
        $this->_view();
    }

        // تسجيل الخروج
    public function signOutAction(){
        session_unset();
        session_destroy();
        $this->headerTo("/dashboard/");
    }
    
}
