<?php
namespace syriashop\controllers;
use \syriashop\lib\Languages;

class ClientController extends AbstractController {
    use \syriashop\lib\Redirect; // استخدام تريت اعادة التحويل
    use \syriashop\lib\FilterInput;
    use \syriashop\lib\Messages;
    use \syriashop\lib\Database;

    // Page Default
    public function defaultAction(){
        if ( !isset($_SESSION['my_info']['name']) ) {
            $this->headerTo('/client/signIn');
        }
        // في الرجوع بعد اللعب
        // if ( isset($_SESSION['my_info']['personal_type']) ) {
        //     session_unset();
        //     session_destroy();
        //     $this->headerTo("/client/signIn");
        // }

        $param = isset($this->_params[0]) ? $this->_params[0] : 1;
        
        $this->_data['param'] = $param;
        
        // عند اختيار نوع الجنس
        if ( isset($this->_params[1]) ) { 
             $_SESSION['my_info']['gender'] = $this->_params[1];
        }

        $this->_view();
    }
    // Choose Person
    public function choosePersonAction(){
        if ( isset($_POST['choose_person']) ) {
            $person = rand(1, 3);
            switch ($person) {
                case 1: $result['value'] = Languages::lang("person1", $_COOKIE['lang']); $result['personal_type'] = 1; break;
                case 2: $result['value'] = Languages::lang("person2", $_COOKIE['lang']); $result['personal_type'] = 2; break;
                case 3: $result['value'] = Languages::lang("person3", $_COOKIE['lang']); $result['personal_type'] = 3; break;
            }
            $_SESSION['my_info']['personal'] = $result['value'];
            $_SESSION['my_info']['personal_type'] = $result['personal_type'];
            header("content-type: application/json");
            echo json_encode($result);
        }
    }
    // Page Sign In
    public function signInAction(){
        if ( isset($_POST["signIn"]) ) {
            $user = new \syriashop\modals\UsersModals();
            $user->name = $this->filterStr($_POST['name']);
            if ( $user->checkName() ) {
                $this->_data['messages'] = $user->showMessage();
            } else {
                $_SESSION['my_info'] = array();
                $_SESSION['my_info']['name'] = $user->name;
                $this->headerTo('/client/default/1');
            }
        }
        if ( isset($_SESSION["myInfo"]['name']) ) {
           $this->headerTo("/client/");
        } else {
            $this->_view();
        }
    }
    // صفحة تغيير اللغة
    public function langAction(){
        if ( isset($this->_params[0]) ) {
            $chooseLang = $this->_params[0];
            setcookie("lang", $chooseLang, strtotime("+30day"), "/", $_SERVER["HTTP_HOST"]);
            $GLOBALS["lang"] = $chooseLang;
            if ( isset($_SERVER["HTTP_REFERER"]) ) {
                $this->headerTo($_SERVER["HTTP_REFERER"]);   
            } else {
                $this->headerTo("/client/default");
            }
        } else {
            $this->headerTo("/client/");
        }
    }
    // تسجيل الخروج
    public function signOutAction(){
        session_unset();
        session_destroy();
        $this->headerTo("/client/signIn");
    }
    
}
